import React from 'react';

import { ReportSection } from 'entities/Report/consts/ReportSection';

import { MetaControlTypes } from 'components/types';
import MetaControlButton from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton';
import { Separator, SignalSidebarFilterItem } from 'components/ui/SectionLayout/SidebarFilterItem';

import style from 'components/ui/SectionLayout/SectionFiltersSidebar/index.css';

interface ISectionFiltersSidebarProps {
    sectionControls?: {
        component: JSX.Element;
    }[];
    processResultControls?: JSX.Element[];
    metaControls?: {
        type: MetaControlTypes;
        onClick?: () => void;
        filterValues?: any;
        section?: ReportSection;
        getData?: (options: any) => void;
        abortGettingData?: () => void;
        xlsxLabel?: string;
        tagsFilter?: string | null;
    }[];
    filtersControls?: {
        title?: string;
        filterComponent: JSX.Element;
    }[];
}

const SectionFiltersSidebar = ({
    metaControls,
    processResultControls,
    filtersControls,
    sectionControls,
}: ISectionFiltersSidebarProps) => {
    return (
        <div className={style.sidebar}>
            {sectionControls?.length ? (
                <div className={style.section_controls}>
                    {sectionControls?.map(({ component }, index) => (
                        <React.Fragment key={index}>{component}</React.Fragment>
                    ))}
                </div>
            ) : null}
            {filtersControls?.length ? (
                <div className={style.filters}>
                    {filtersControls?.map((filter: { title?: string; filterComponent: JSX.Element }, index, arr) => {
                        let { title, filterComponent } = filter;

                        return (
                            <div key={title ?? index}>
                                <SignalSidebarFilterItem
                                    title={title}
                                    filterComponent={filterComponent}
                                />
                                {index !== arr.length - 1 ? <Separator /> : null}
                            </div>
                        );
                    })}
                </div>
            ) : null}
            {/*Last pixel in width cover sidebar border*/}
            {metaControls?.length || processResultControls?.length ? (
                <div className={style.meta_controls}>
                    {metaControls?.map((metaControl) => {
                        let { type, onClick, filterValues, section, getData, abortGettingData, xlsxLabel, tagsFilter } =
                            metaControl;

                        return (
                            <MetaControlButton
                                key={type}
                                type={type}
                                onClick={onClick}
                                filterValues={filterValues}
                                section={section}
                                getData={getData}
                                xlsxLabel={xlsxLabel}
                                tagsFilter={tagsFilter}
                                abortGettingData={abortGettingData}
                            />
                        );
                    }) ?? processResultControls?.map((processResultControl) => processResultControl)}
                </div>
            ) : null}
        </div>
    );
};

export default SectionFiltersSidebar;
