import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import MainText2 from 'components/ui/Text/MainText2';
import Subhead1 from 'components/ui/Text/Subhead1';

import Arrow from 'components/ui/SectionLayout/SectionSidebarTabs/SectionSidebarTab/arrow.component.svg';

import style from 'components/ui/SectionLayout/SectionSidebarTabs/SectionSidebarTab/index.css';

export interface ISectionSidebarTabProps {
    title: string;
    description?: any;
    onClick: () => void;
    selected?: boolean;
}

const SectionSidebarTab = ({ title, description, onClick, selected }: ISectionSidebarTabProps) => {
    return (
        <div
            className={`${style.section_sidebar_tab} ${selected ? style.selected : ''}`}
            onClick={onClick}
        >
            <div className={style.info}>
                {selected ? (
                    <Subhead1>{title || EMPTY_DATA}</Subhead1>
                ) : (
                    <MainText2 className={style.title}>{title || EMPTY_DATA}</MainText2>
                )}
                {description ? <div>{description}</div> : null}
            </div>
            <div className={style.arrow_container}>
                <Arrow />
            </div>
        </div>
    );
};

export default SectionSidebarTab;
