import * as React from 'react';

import SectionSidebarTabs from 'components/ui/SectionLayout/SectionSidebarTabs/index';
import SectionSidebarTab from 'components/ui/SectionLayout/SectionSidebarTabs/SectionSidebarTab/index';

const TAB_NAME = 'Title';
const TAB_ON_CLICK = () => {};
const Container = ({ children }) => <div style={{ width: '200px' }}>{children}</div>;

export default { title: 'Section Layout/Section Sidebar Tabs', component: SectionSidebarTabs };
export const _empty_tab = () => {
    return (
        <Container>
            <SectionSidebarTab
                title=""
                onClick={TAB_ON_CLICK}
            />
        </Container>
    );
};

export const _default_tab = () => {
    return (
        <Container>
            <SectionSidebarTab
                title={TAB_NAME}
                onClick={TAB_ON_CLICK}
            />
        </Container>
    );
};

export const _hovered = () => {
    return (
        <Container>
            <SectionSidebarTab
                title={TAB_NAME}
                onClick={TAB_ON_CLICK}
            />
        </Container>
    );
};

export const _active = () => {
    return (
        <Container>
            <SectionSidebarTab
                title={TAB_NAME}
                onClick={TAB_ON_CLICK}
            />
        </Container>
    );
};

export const _selected = () => {
    return (
        <Container>
            <SectionSidebarTab
                title={TAB_NAME}
                onClick={TAB_ON_CLICK}
                selected
            />
        </Container>
    );
};

_hovered.parameters = { pseudo: { hover: true } };
_active.parameters = { pseudo: { active: true } };

export const _with_description = () => {
    return (
        <Container>
            <SectionSidebarTab
                title={TAB_NAME}
                description="Some description"
                onClick={TAB_ON_CLICK}
            />
        </Container>
    );
};

export const _default_tabs = () => {
    return (
        <Container>
            <SectionSidebarTabs
                tabs={[
                    { title: TAB_NAME, onClick: TAB_ON_CLICK, selected: true },
                    { title: TAB_NAME, onClick: TAB_ON_CLICK },
                    { title: TAB_NAME, onClick: TAB_ON_CLICK },
                    { title: TAB_NAME, onClick: TAB_ON_CLICK },
                    { title: TAB_NAME, onClick: TAB_ON_CLICK },
                ]}
            />
        </Container>
    );
};
