import React from 'react';

import SectionSidebarTab, {
    ISectionSidebarTabProps,
} from 'components/ui/SectionLayout/SectionSidebarTabs/SectionSidebarTab';

import style from 'components/ui/SectionLayout/SectionSidebarTabs/index.css';

interface ISectionSidebarTabsProps {
    tabs: ISectionSidebarTabProps[];
}

const SectionSidebarTabs = ({ tabs }: ISectionSidebarTabsProps) => {
    return (
        <div className={style.section_sidebar_tabs}>
            {tabs.length
                ? tabs.map((tab) => {
                      let { title, description, onClick, selected } = tab;

                      return (
                          <SectionSidebarTab
                              key={title}
                              title={title}
                              description={description ?? null}
                              onClick={onClick}
                              selected={selected ?? false}
                          />
                      );
                  })
                : null}
        </div>
    );
};

export default SectionSidebarTabs;
