import React from 'react';

import style from 'components/ui/SectionLayout/SidebarFilterItem/index.css';

interface ISignalSidebarFilterItemProps {
    title?: string;
    filterComponent: JSX.Element;
}

export const SignalSidebarFilterItem = ({ title, filterComponent }: ISignalSidebarFilterItemProps) => {
    return (
        <div className={style.signal_sidebar_filter_item}>
            {title ? <div className={style.title}>{title}</div> : null}
            {filterComponent}
        </div>
    );
};

export const Separator = () => <div className={style.separator} />;
