import * as React from 'react';
import { Story } from '@storybook/react';

import Select from 'components/ui/Select/index';

const MOCK_OPTION_1 = { value: 'option_1', text: 'Option 1' };
const MOCK_OPTION_2 = { value: 'option_2', text: 'Option 2' };
const MOCK_OPTION_3 = { value: 'option_3', text: 'Option 3' };
const MOCK_OPTION_4 = { value: 'option_4', text: 'Option 4' };
const MOCK_OPTION_5 = { value: 'option_5', text: 'Option 5' };

const MOCK_OPTIONS = [MOCK_OPTION_1, MOCK_OPTION_2, MOCK_OPTION_3, MOCK_OPTION_4, MOCK_OPTION_5];

export default { title: 'UI/Select' };

const Template: Story<any> = (args) => <Select {...args} />;

export const EmptyNoProps = Template.bind({});
EmptyNoProps.args = {};

export const Empty = Template.bind({});
Empty.args = { placeholder: 'Select placeholder', options: [] };

export const WithOptions = Template.bind({});
WithOptions.args = {
    placeholder: 'Select placeholder',
    options: MOCK_OPTIONS,
};

export const WithOptionsAndSearch = Template.bind({});
WithOptionsAndSearch.args = {
    placeholder: 'Select placeholder',
    options: MOCK_OPTIONS,
    withSearch: true,
};

export const WithSmallContainer = () => (
    <div style={{ height: '75px', border: '1px dashed black', overflow: 'auto' }}>
        <Select
            onSelect={() => {}}
            options={MOCK_OPTIONS}
            placeholder="Select placeholder"
        />
    </div>
);
