import React from 'react';
import cn from 'classnames/bind';

import { CarStatusType } from 'entities/Car/consts/CarStatusType';
import { getCarStatus } from 'entities/Car/helpers/getCarStatus/getCarStatus';

import styles from 'components/ui/Status/index.css';

export interface IStatusProps {
    className?: string;
    statusType: CarStatusType;
    big?: boolean;
    dark?: boolean;
    customLabel?: string;
}

const cx = cn.bind(styles);

export const Status = (props: IStatusProps) => {
    let { className, statusType, big, dark, customLabel } = props;

    return (
        <div className={cx(styles.status, { big, dark }, [statusType, className])}>
            <div className={styles.icon} />
            <span>{customLabel ? customLabel : getCarStatus(statusType)}</span>
        </div>
    );
};
