import React from 'react';

import { ENTER_KEY_CODE } from 'constants/constants';

import style from 'components/ui/Switcher/index.css';

interface ISwitcherProps {
    checked: boolean;
    onChange: (value: boolean) => void;
    disabled?: boolean;
}

export const Switcher = (props: ISwitcherProps) => {
    let { checked, disabled, onChange } = props;

    const onClick = () => {
        if (!disabled) {
            onChange(!checked);
        }
    };

    const onKeyUp = (event: any) => {
        if (!disabled) {
            const code = event.keyCode ? event.keyCode : event.which;
            if (code == ENTER_KEY_CODE) {
                onClick();
            }
        }
    };

    return (
        <input
            type="checkbox"
            checked={checked}
            disabled={disabled}
            className={style.checkbox}
            onChange={onClick}
            onKeyUp={onKeyUp}
        />
    );
};
