import React from 'react';

import ITableValueType from 'components/types';
import { getShiftNumberDisplayString } from 'components/ui/Table/getShiftNumberDisplayString';

import style from 'components/ui/Table/ShiftLabel/index.css';

const MINIMAL_SHIFT_VALUE = 0.1;

interface IShiftLabel {
    shift_type: ITableValueType;
    value: number | null;
    isRiseIsNegative?: boolean; //if its true, rising of value is bad for business
}

const ShiftLabel = (props: IShiftLabel) => {
    let { shift_type, value, isRiseIsNegative } = props;

    return value !== null && value !== undefined && value !== 0 && Math.abs(value ?? 0) >= MINIMAL_SHIFT_VALUE ? (
        <div className={style.shift_label}>
            <div
                className={`${style.arrow_icon} ${
                    value < 0
                        ? isRiseIsNegative
                            ? style.arrow_icon_decrease_good
                            : style.arrow_icon_decrease
                        : isRiseIsNegative
                        ? style.arrow_icon_increase_bad
                        : style.arrow_icon_increase
                }`}
            />
            <div
                className={
                    `${style.shift_value} ` +
                    ` ${
                        value === 0
                            ? style.zero
                            : value < 0
                            ? isRiseIsNegative
                                ? style.increase
                                : style.decrease
                            : isRiseIsNegative
                            ? style.decrease
                            : style.increase
                    }`
                }
            >
                {getShiftNumberDisplayString(value, shift_type)}
            </div>
        </div>
    ) : null;
};

export default ShiftLabel;
