import React from 'react';
import { useHistory } from 'react-router-dom';

import { ENTER_KEY_CODE } from 'constants/constants';

import style from 'components/ui/Table/TableLink/index.css';

interface ITableLinkProps {
    children: any;
    link: string;
    disabled?: boolean;
}

const TableLink = ({ children, link, disabled }: ITableLinkProps) => {
    let history = useHistory();

    const onClick = (e?: any) => {
        e?.stopPropagation();
        if (!disabled) {
            history.push(link);
        }
    };

    const onKeyUp = (event: any) => {
        const code = event.keyCode ? event.keyCode : event.which;
        if (code == ENTER_KEY_CODE) {
            onClick();
        }
    };

    return (
        <div
            onClick={onClick}
            onKeyUp={onKeyUp}
            tabIndex={0}
            className={`${style.table_link} ${disabled ? style.disabled : ''}`}
        >
            {children}
        </div>
    );
};

export default TableLink;
