import React from 'react';
import { Link } from 'react-router-dom';

import style from 'components/ui/Table/TableLinkLabel/index.css';

interface ITableLinkLabelProps {
    link?: string;
    children?: React.ReactNode;
}

const TableLinkLabel = (props: ITableLinkLabelProps) => {
    return (
        <Link to={props.link ?? '/'}>
            <div className={style.table_link_label_container}>
                <div className={style.table_link_label}>
                    {props.children}
                    <div className={style.table_link_label_arrow} />
                </div>
            </div>
        </Link>
    );
};

export default TableLinkLabel;
