//return formatted string for SHIFT value (with minus)
import { EMPTY_DATA } from 'constants/constants';

import ITableValueType from 'components/types';
import { getIconByType } from 'components/ui/Table/getIconByType';

export const getNumberDisplayString = (shiftValue: number, shiftType: ITableValueType): string => {
    if (shiftValue !== null && shiftValue !== undefined) {
        let roundedValue =
            Math.abs(shiftValue) > 0 && Math.abs(shiftValue) < 1 ? +shiftValue.toFixed(1) : Math.round(shiftValue);

        return `${roundedValue.toLocaleString('ru')}${getIconByType(shiftType)}`;
    } else {
        return EMPTY_DATA;
    }
};
