//return formatted string for SHIFT value (without minus)
import { EMPTY_DATA } from 'constants/constants';

import ITableValueType from 'components/types';
import { getIconByType } from 'components/ui/Table/getIconByType';

export const getShiftNumberDisplayString = (shiftValue: number, shiftType: ITableValueType): string => {
    if (shiftValue !== null && shiftValue !== undefined) {
        let roundedValue =
            Math.abs(shiftValue) > 0 && Math.abs(shiftValue) < 1 ? +shiftValue.toFixed(1) : Math.round(shiftValue);

        return `${Math.abs(roundedValue).toLocaleString('ru')}${getIconByType(shiftType)}`;
    } else {
        return EMPTY_DATA;
    }
};
