import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Error while loading data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Error while loading data',
        ru: 'Не получилось загрузить данные',
        cs: 'Chyba při načítání dat',
    },
    'No information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No information',
        ru: 'Нет информации',
        cs: 'Žádné informace',
    },
    'Show more': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show more',
        ru: 'Показать ещё',
        cs: 'Zobrazit více',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
