import * as React from 'react';
import { MemoryRouter } from 'react-router';

import Table from 'components/ui/Table/index';

import style from 'components/ui/Table/test_index.css';

export default {
    title: 'UI/Table',
    component: Table,
};

export const _without_content = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[]}
            />
        </MemoryRouter>
    );
};

export const _only_header = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                    },
                    {
                        key: 'header2',
                        displayName: 'Header 2',
                    },
                    {
                        key: 'header3',
                        displayName: 'Header 3',
                    },
                ]}
            />
        </MemoryRouter>
    );
};

//row are mapped by header, so table need to inform is there no header
export const _only_content = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[
                    {
                        data: { header1: 'row 1-1' },
                        meta: { key: 'row1' },
                    },
                ]}
                header={[]}
            />
        </MemoryRouter>
    );
};

export const _header_and_content = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[
                    {
                        data: {
                            header1: 'row 1-1',
                            header2: 'row 1-2',
                            header3: 'row 1-3',
                        },
                        meta: { key: 'row1' },
                    },
                    {
                        data: {
                            header1: 'row 2-1',
                            header2: 'row 2-2',
                            header3: 'row 2-3',
                        },
                        meta: { key: 'row2' },
                    },
                    {
                        data: {
                            header1: 'row 3-1',
                            header2: 'row 3-2',
                            header3: 'row 3-3',
                        },
                        meta: { key: 'row3' },
                    },
                ]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                    },
                    {
                        key: 'header2',
                        displayName: 'Header 2',
                    },
                    {
                        key: 'header3',
                        displayName: 'Header 2',
                    },
                ]}
            />
        </MemoryRouter>
    );
};

export const _loading = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[]}
                isLoading
            />
        </MemoryRouter>
    );
};

export const _error = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[]}
                error={new Error()}
            />
        </MemoryRouter>
    );
};

export const _error_with_reload = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[]}
                error={new Error()}
                reloadFunction={() => {}}
            />
        </MemoryRouter>
    );
};

export const _get_more = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[]}
                getMore={{ canGetMore: true }}
            />
        </MemoryRouter>
    );
};

export const _description = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                        description: 'description for Header 1',
                    },
                ]}
            />
        </MemoryRouter>
    );
};

export const _disabled_sorting = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                        sorting: true,
                    },
                ]}
            />
        </MemoryRouter>
    );
};

export const _enabled_desc_true_sorting = () => {
    return (
        <MemoryRouter initialEntries={[{ search: 'order_field=header1&order_desc=true' }]}>
            <Table
                tableData={[]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                        sorting: true,
                    },
                ]}
            />
        </MemoryRouter>
    );
};

export const _enabled_desc_false_sorting = () => {
    return (
        <MemoryRouter initialEntries={[{ search: 'order_field=header1&order_desc=false' }]}>
            <Table
                tableData={[]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                        sorting: true,
                    },
                ]}
            />
        </MemoryRouter>
    );
};

export const _row_classname = () => {
    return (
        <MemoryRouter>
            <Table
                tableData={[
                    {
                        data: { header1: 'row 1-1' },
                        meta: {
                            key: 'row1',
                            className: style.test_row_classname,
                        },
                    },
                ]}
                header={[
                    {
                        key: 'header1',
                        displayName: 'Header 1',
                    },
                ]}
            />
        </MemoryRouter>
    );
};
