import { Direction } from 'components/ui/DescriptionIcon';

export interface IHeaderInfo {
    key: string;
    displayName: string;
    description?: string;
    descriptionDirection?: Direction.LEFT | Direction.RIGHT;
    sorting?: boolean;
}

export interface ITableRowData {
    data: {
        [key: string]: any;
    };
    meta: {
        key: string;
        className?: string;
        onClick?: () => void;
    };
}

export interface ITableGetMore {
    canGetMore: boolean;
    onGetMoreClick?: () => void;
    isMoreLoading?: boolean;
    getMoreTitle?: string;
}

export interface ITableSorting {
    [key: string]: { enabled: boolean; desc: boolean };
}
