import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { ITabsItem, TabsSize } from 'components/ui/Tabs/types';
import Header4 from 'components/ui/Text/Header4';
import Subhead1 from 'components/ui/Text/Subhead1';

import style from 'components/ui/Tabs/Tab/index.css';

interface ITabProps extends ITabsItem {
    active: boolean;
    onClick: (any) => void;
    size?: TabsSize;
    tight?: boolean;
}

const Tab = (props: ITabProps) => {
    let { name, link, active, onClick: onClickProps, size = TabsSize.S, tight } = props;
    let label = name || EMPTY_DATA;

    return (
        <div
            key={link}
            className={`${style.tab} ${size ? style[size] : ''} ${tight ? style.tight : ''} ${
                active ? style.active : ''
            }`}
            onClick={onClickProps}
        >
            {size === TabsSize.M ? (
                <Header4 className={style.tab_title}>{label}</Header4>
            ) : (
                <Subhead1 className={style.tab_title}>{label}</Subhead1>
            )}
        </div>
    );
};

export default Tab;
