import * as React from 'react';

import Tabs from 'components/ui/Tabs/index';
import Tab from 'components/ui/Tabs/Tab';
import { TabsSize } from 'components/ui/Tabs/types';

const TAB_NAME = 'Tab';
const TAB_LINK = '';
const TAB_ON_CLICK = () => {};

export default { title: 'UI/Tabs', component: Tabs };
export const _empty_tab = () => {
    return (
        <Tab
            name=""
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={false}
        />
    );
};

export const _default_tab = () => {
    return (
        <Tab
            name={TAB_NAME}
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={false}
        />
    );
};

export const _hovered_tab = () => {
    return (
        <Tab
            name={TAB_NAME}
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={false}
        />
    );
};

export const _pressed_tab = () => {
    return (
        <Tab
            name={TAB_NAME}
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={false}
        />
    );
};

export const _active_tab = () => {
    return (
        <Tab
            name={TAB_NAME}
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={true}
        />
    );
};

export const _tight_tab = () => {
    return (
        <Tab
            name={TAB_NAME}
            link={TAB_LINK}
            tight
            onClick={TAB_ON_CLICK}
            active={true}
        />
    );
};

export const _s_size_tab = () => {
    return (
        <Tab
            size={TabsSize.S}
            name={TAB_NAME}
            link={TAB_LINK}
            onClick={TAB_ON_CLICK}
            active={false}
        />
    );
};

_hovered_tab.parameters = { pseudo: { hover: true } };
_pressed_tab.parameters = { pseudo: { active: true } };

export const _default_tabs_m = () => {
    return (
        <Tabs
            size={TabsSize.M}
            onChange={TAB_ON_CLICK}
            tabs={[
                { link: `TAB_LINK_1`, name: TAB_NAME },
                { link: `TAB_LINK_2`, name: TAB_NAME },
                { link: `TAB_LINK_3`, name: TAB_NAME },
                { link: `TAB_LINK_4`, name: TAB_NAME },
                { link: `TAB_LINK_5`, name: TAB_NAME },
            ]}
        />
    );
};

export const _default_tabs_s = () => {
    return (
        <Tabs
            size={TabsSize.S}
            onChange={TAB_ON_CLICK}
            tabs={[
                { link: `TAB_LINK_1`, name: TAB_NAME },
                { link: `TAB_LINK_2`, name: TAB_NAME },
                { link: `TAB_LINK_3`, name: TAB_NAME },
                { link: `TAB_LINK_4`, name: TAB_NAME },
                { link: `TAB_LINK_5`, name: TAB_NAME },
            ]}
        />
    );
};
