import React, { useEffect, useState } from 'react';

import Tab from 'components/ui/Tabs/Tab';
import { ITabsItem, TabsSize } from 'components/ui/Tabs/types';

import style from 'components/ui/Tabs/index.css';

interface ITabsProps {
    tabs: ITabsItem[];
    activeTab?: string | null;
    onChange: (link: string) => void;
    size?: TabsSize;
    tight?: boolean;
    withoutBorder?: boolean;
}

const Tabs = (props: ITabsProps) => {
    let { tabs, activeTab: activeTabProps, onChange, tight, size = TabsSize.S, withoutBorder } = props;

    const [activeTab, setActiveTab] = useState<string | null>(null);

    useEffect(() => {
        if (activeTabProps) {
            setActiveTab(activeTabProps);
        }
    }, [activeTabProps]);

    const onTabClick = (link: string) => {
        setActiveTab(link);
        onChange(link);
    };

    return (
        <div className={`${style.tabs} ${size ? style[size] : ''} ${withoutBorder ? style.without_border : ''}`}>
            {tabs.map((tab) => {
                let { name, link } = tab;

                return (
                    <Tab
                        key={link}
                        size={size}
                        name={name}
                        link={link}
                        active={activeTab === link}
                        tight={tight}
                        onClick={onTabClick.bind(null, link)}
                    />
                );
            })}
        </div>
    );
};

export default Tabs;
