import React from 'react';

import Tabs from 'components/ui/Tabs';
import { ITabsItem, TabsSize } from 'components/ui/Tabs/types';

interface ITabsHeaderItem extends ITabsItem {
    exact?: boolean;
}

interface ITabsHeaderProps {
    tabs: ITabsHeaderItem[];
    activeTab?: string | null;
    onChange: (link: string) => void;
}

const TabsHeader = (props: ITabsHeaderProps) => {
    let { tabs, activeTab: activeTabProps, onChange } = props;

    return (
        <Tabs
            size={TabsSize.M}
            withoutBorder
            tabs={tabs}
            activeTab={activeTabProps}
            onChange={onChange}
        />
    );
};

export default TabsHeader;
