import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Header1/index.css';

const Header1 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.MEDIUM}
            className={`${style.header1} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Header1;
