import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Header2/index.css';

const Header2 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.MEDIUM}
            className={`${style.header2} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Header2;
