import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Header3/index.css';

const Header3 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.MEDIUM}
            className={`${style.header3} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Header3;
