import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Header4/index.css';

const Header4 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.MEDIUM}
            className={`${style.header4} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Header4;
