import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Main2/index.css';

const Main2 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.REGULAR}
            className={`${style.main2} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Main2;
