import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/MainText2/index.css';

const MainText2 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.REGULAR}
            className={`${style.main_text_2} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default MainText2;
