import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/MainText3/index.css';

const MainText3 = ({ children, title, className }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            fontWeight={FontWeight.REGULAR}
            className={`${style.main_text_3} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default MainText3;
