import React from 'react';

import Text, { FontWeight, ICommonTextProps } from 'components/ui/Text/index';

import style from 'components/ui/Text/Subhead1/index.css';

const Subhead1 = ({ children, title, className, isLoading, shimmerSize }: ICommonTextProps) => {
    return (
        <Text
            title={title}
            isLoading={isLoading}
            shimmerSize={shimmerSize}
            fontWeight={FontWeight.MEDIUM}
            className={`${style.subhead1} ${className ?? ''}`}
        >
            {children}
        </Text>
    );
};

export default Subhead1;
