import React from 'react';

import style from 'components/ui/Text/index.css';

export enum FontWeight {
    REGULAR = 'regular',
    MEDIUM = 'medium',
}

export enum ShimmerSize {
    S = 's',
    M = 'm',
}

interface IShimmerText {
    isLoading?: boolean;
    shimmerSize?: ShimmerSize;
}

export interface ITextProps extends React.PropsWithChildren<{}>, IShimmerText {
    fontWeight?: FontWeight;
    className?: string;
    title?: string;
}

export interface ICommonTextProps extends React.PropsWithChildren<{}>, IShimmerText {
    className?: string;
    title?: string;
}

const Text = ({ children, className, fontWeight, title, shimmerSize, isLoading }: ITextProps) => {
    return (
        <span
            className={`${style.text} ${fontWeight ? style[fontWeight] : style[FontWeight.REGULAR]} ${
                isLoading ? `${style.shimmer} ${style[`shimmer_size_` + shimmerSize]}` : ''
            } ${className}`}
            title={title}
        >
            {children}
        </span>
    );
};

export default Text;
