import * as React from 'react';

import { Direction } from 'components/ui/DescriptionIcon';
import Tooltip from 'components/ui/Tooltip/index';

const TITLE = 'Tooltip';

const MockTooltipItem = ({ children }) => {
    return (
        <div
            style={{
                width: '5em',
                height: '2em',
                margin: '5em',
                border: '1px dashed #eaeaea',
                position: 'relative',
            }}
        >
            {children}
        </div>
    );
};

export default { title: 'Tooltip', component: Tooltip };

//Primary
export const _top = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.TOP}
            />
        </MockTooltipItem>
    );
};

export const _right = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.RIGHT}
            />
        </MockTooltipItem>
    );
};

export const _bottom = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.BOTTOM}
            />
        </MockTooltipItem>
    );
};

export const _left = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.LEFT}
            />
        </MockTooltipItem>
    );
};

//Small
export const _top_small = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.TOP}
                small
            />
        </MockTooltipItem>
    );
};

export const _right_small = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.RIGHT}
                small
            />
        </MockTooltipItem>
    );
};

export const _bottom_small = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.BOTTOM}
                small
            />
        </MockTooltipItem>
    );
};

export const _left_small = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                direction={Direction.LEFT}
                small
            />
        </MockTooltipItem>
    );
};

//Title
export const _empty_title = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title=""
                direction={Direction.TOP}
            />
        </MockTooltipItem>
    );
};

export const _normal_title = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title="Normal Title"
                direction={Direction.TOP}
            />
        </MockTooltipItem>
    );
};

export const _long_title_top = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title="Very long long long long long Title"
                direction={Direction.TOP}
            />
        </MockTooltipItem>
    );
};

export const _long_title_right = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title="Very long long long long long Title"
                direction={Direction.RIGHT}
            />
        </MockTooltipItem>
    );
};

//Description
export const _with_description = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                description="Description"
                direction={Direction.BOTTOM}
            />
        </MockTooltipItem>
    );
};

export const _with_long_description = () => {
    return (
        <MockTooltipItem>
            <Tooltip
                title={TITLE}
                description="Very very very very very very very long Description"
                direction={Direction.BOTTOM}
            />
        </MockTooltipItem>
    );
};
