import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { Direction } from 'components/ui/DescriptionIcon';

import style from 'components/ui/Tooltip/index.css';

const ONE_LETTER_WIDTH = 6;

export interface ITooltipProps {
    title: any;
    description?: any;
    direction?: Direction;
    small?: boolean;
    className?: string;
}

const Tooltip = (props: ITooltipProps) => {
    let { title, description, direction = Direction.RIGHT, small, className } = props;

    const getTextLength = (text: string) => {
        const getWordsLettersLength = (words: string[], widthWordsCount: number) => {
            if (words.length) {
                return words.slice(0, widthWordsCount).reduce((letterLength, word) => {
                    letterLength += word.length + 1;

                    return letterLength;
                }, 0);
            } else {
                return 0;
            }
        };

        if (text?.length) {
            const MIN_WIDTH_WORDS_COUNT = 5;
            const MAX_WIDTH_WORDS_COUNT = 10;
            let words = text.split(' ').sort((word1, word2) => word1?.length - word2?.length);

            return {
                maxWidth: getWordsLettersLength(words, MAX_WIDTH_WORDS_COUNT),
                minWidth: getWordsLettersLength(words, MIN_WIDTH_WORDS_COUNT),
            };
        } else {
            return null;
        }
    };

    let titleLength = getTextLength(title);
    let descriptionLength = getTextLength(description);

    let styles =
        titleLength !== null || descriptionLength !== null
            ? {
                  maxWidth: `${
                      Math.max(titleLength?.maxWidth ?? 0, descriptionLength?.maxWidth ?? 0) * ONE_LETTER_WIDTH
                  }px`,
                  minWidth: `${
                      Math.max(titleLength?.minWidth ?? 0, descriptionLength?.minWidth ?? 0) * ONE_LETTER_WIDTH
                  }px`,
              }
            : {};

    return (
        <div
            className={`${style.tooltip} ${style[direction]} ${small ? style.small : ''} ${className ? className : ''}`}
            style={styles}
        >
            <div className={style.text}>
                <div className={style.title}>{title || EMPTY_DATA}</div>
                {description ? <div className={style.description}>{description || EMPTY_DATA}</div> : null}
            </div>
        </div>
    );
};

export default Tooltip;
