import React from 'react';

import style from 'components/ui/Widget/index.css';

interface IWidgetProps {
    headerComponent?: React.ClassicElement<any> | null;
    contentComponent: React.ClassicElement<any> | null;
    topLevel?: boolean;
    fullHeight?: boolean;
}

const Widget = (props: IWidgetProps) => {
    let { headerComponent, contentComponent, topLevel, fullHeight } = props;

    return (
        <div
            className={`${style.widget_container} ${topLevel ? style.top_level : ''} ${
                fullHeight ? style.fullHeight : ''
            }`}
        >
            {headerComponent && <div>{headerComponent}</div>}
            <div className={`${style.widget_content} ${headerComponent ? style.with_header : ''}`}>
                {contentComponent}
            </div>
        </div>
    );
};

export default Widget;
