import React from 'react';

import { ITooltipProps } from 'components/ui/Tooltip';

const GlobalTooltipContext = React.createContext<{
    show: boolean;
    elementPosition: [number | null, number | null];
    elementSize: [number | null, number | null];
    tooltipOptions: ITooltipProps | null;
    setElementPosition: (position: [number | null, number | null]) => void;
    setElementSize: (size: [number | null, number | null]) => void;
    setShow: (auth: boolean) => void;
    setTooltipOptions: (options: ITooltipProps | null) => void;
}>({
    show: false,
    elementPosition: [null, null],
    elementSize: [null, null],
    tooltipOptions: null,
    setShow: () => {},
    setElementPosition: () => {},
    setElementSize: () => {},
    setTooltipOptions: () => {},
});

export default GlobalTooltipContext;
