import { UseCarData, UseCarReq, UseCarRes, UseCarServerRes } from 'entities/Car/api/useCar/useCar';
import { carParser } from 'entities/Car/helpers/carParser/carParser';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export function fetchCar(data: UseCarData, cache: CacheRequestContext) {
    const requestData: UseCarReq = {
        car_id: data.carId,
    };

    if (data.sensors) {
        requestData.sensors = data.sensors.join(',');
    }

    requestData.traits = [
        'ReportShowAllModels',
        'ReportLocationDetails',
        'ReportAggressiveScore',
        'ReportSensorTimestamp',
        'ReportTagDetails',
        'ReportVIN',
        'ReportIMEI',
        'ReportSignalq',
        'ReportCommonSpeed',
    ].join(',');

    return fetchRequest<UseCarReq, UseCarRes, UseCarServerRes>('/api/leasing/car/list', requestData, {
        method: 'GET',
        parser: carParser,
        cache,
    });
}
