import { CarModelSchema } from 'entities/Car/types/CarModelSchema';

import { fetchRequest, FetchRequestResult } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchCarModelData {}

export interface FetchCarModelsServerRes {
    car_models: CarModelSchema[];
}

let MODELS_CACHE: Optional<FetchRequestResult<CarModelSchema[]>> = undefined;

export function fetchCarModels(text: string, cache?: CacheRequestContext): FetchRequestResult<CarModelSchema[]> {
    if (!MODELS_CACHE) {
        MODELS_CACHE = fetchRequest<FetchCarModelData, CarModelSchema[], FetchCarModelsServerRes>(
            'api/leasing/model/info',
            {},
            {
                cache,
                parser(res) {
                    return res.car_models;
                },
            },
        );
    }

    return MODELS_CACHE.transform<CarModelSchema[]>((data: CarModelSchema[]) => {
        const token = text.trim().toLowerCase();

        if (!text) {
            return data;
        }

        return data.filter((item) => {
            return [item.name, item.fuel_type].some((part) => {
                return part.toLowerCase().includes(token);
            });
        });
    });
}
