import { createFile } from 'shared/helpers/createFile/createFile';
import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchCarRentalAgreementData {
    session_id: string;
}

export interface FetchCarRentalAgreementServerRes {
    agreement: string;
}

export type FetchCarRentalAgreementRes = File;

function rentalAgreementParser(res: FetchCarRentalAgreementServerRes): FetchCarRentalAgreementRes {
    const htmlString = `<!DOCTYPE html><html lang="en"><head><meta charset="UTF-8"/> <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"/><meta http-equiv="X-UA-Compatible" content="ie=edge"/><title>Rental Agreement</title></head><body>${res.agreement}</body></html>`;

    return createFile(htmlString, `rental_agreement_${Date.now()}.html`, 'text/html');
}

export function fetchCarRentalAgreement(sessionId: string, userId: string, cache?: CacheRequestContext) {
    return fetchRequest<FetchCarRentalAgreementData, FetchCarRentalAgreementRes, FetchCarRentalAgreementServerRes>(
        '/api/leasing/sessions/agreement',
        {
            session_id: sessionId,
        },
        { parser: rentalAgreementParser, headers: { userIdDelegation: userId }, cache },
    );
}
