import { CarModelSchema } from 'entities/Car/types/CarModelSchema';
import { CarSearchSchema } from 'entities/Car/types/CarSearchSchema';
import { CarSearchServerSchema } from 'entities/Car/types/CarSearchServerSchema';

import { fetchRequest, FetchRequestResult } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchCarsSearchData {
    has_all_of: string;
    what: 'cars';
    limit: number;
}

export interface FetchCarsSearchServerRes {
    objects: {
        cars: CarSearchServerSchema[];
        models: Record<string, CarModelSchema>;
    };
}

export interface FetchCarsListData {
    limit: number;
}

export interface FetchCarsListServerRes {
    cars: CarSearchServerSchema[];
    models: Record<string, CarModelSchema>;
}

export function fetchCarsSearch(text: string, cache?: CacheRequestContext): FetchRequestResult<CarSearchSchema[]> {
    if (!text) {
        return fetchRequest<FetchCarsListData, CarSearchSchema[], FetchCarsListServerRes>(
            '/api/leasing/car/list',
            {
                limit: 10,
            },
            {
                cache,
                parser(res) {
                    const models = res.models ?? {};
                    const cars = res.cars ?? [];

                    return cars.map((car) => {
                        return {
                            ...car,
                            model_name: models[car.model_id]?.name,
                        };
                    });
                },
            },
        );
    }

    return fetchRequest<FetchCarsSearchData, CarSearchSchema[], FetchCarsSearchServerRes>(
        '/api/leasing/search',
        {
            has_all_of: text,
            what: 'cars',
            limit: 10,
        },
        {
            cache,
            parser(res) {
                const models = res.objects.models ?? {};
                const cars = res.objects?.cars ?? [];

                return cars.map((car) => {
                    return {
                        ...car,
                        model_name: models[car.model_id]?.name,
                    };
                });
            },
        },
    );
}
