import { ONE_MILLISECOND } from 'constants/constants';

import { postCarOffer, PostCarOfferData } from 'features/CarBooking/api/postCarOffer/postCarOffer';
import { postCarRental } from 'features/CarBooking/api/postCarRental/postCarRental';
import { updateCarOffer } from 'features/CarBooking/api/updateCarOffer/updateCarOffer';

import { CarOfferFormSchema } from 'entities/Car/types/CarOfferFormSchema';
import { CarOfferSchema } from 'entities/Car/types/CarOfferSchema';

import { getTimestampFromDateTime } from 'shared/helpers/getTimestampFromDateTime/getTimestampFromDateTime';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface PostCarRentalFormOptions {
    tagId: Optional<string>;
    offerId: string;
    prev: CarOfferSchema;
}

export async function postCarRentalForm(
    data: CarOfferFormSchema,
    options?: PostCarRentalFormOptions,
    cache?: CacheRequestContext,
) {
    const offerData: PostCarOfferData = {
        car_id: data.car.id,

        limit_km_per_day: Number(data.limit_km_per_day),
        overrun_cost_per_km: Number(data.overrun_cost_per_km),
        offer_options: data.offer_options || {},
        return_location: data.return_location.location,
        delivery_location: data.delivery_location.location,
        return_location_name: data.return_location.name,
        delivery_location_name: data.delivery_location.name,
        since: getTimestampFromDateTime(data.since, data.since_time) * ONE_MILLISECOND,
        until: getTimestampFromDateTime(data.until, data.until_time) * ONE_MILLISECOND,
        insurance_type: data.insurance_type,
        comment: data.comment,
        currency: data.currency,
        total_payment: Number(data.total_payment),
        deposit: Number(data.deposit),
        status: data.status,
    };

    if (options && options.offerId) {
        // update
        await updateCarOffer(options.tagId, { ...options.prev, ...offerData, offer_id: options.offerId }, cache);
    } else {
        // create
        const offerId = await postCarOffer(offerData);

        const user = data.user;
        const userPayload = user.id ? { client_id: user.id } : user;

        return postCarRental({ ...userPayload, offer_id: offerId }, cache);
    }
}
