import { carParser } from 'entities/Car/helpers/carParser/carParser';
import { CarCommonSpeedTraitSchema } from 'entities/Car/types/CarCommonSpeedTraitSchema';
import { CarIMEITraitSchema } from 'entities/Car/types/CarIMEITraitSchema';
import { CarModelSchema } from 'entities/Car/types/CarModelSchema';
import { CarSchema } from 'entities/Car/types/CarSchema';
import { CarSignalqTraitSchema } from 'entities/Car/types/CarSignalqTraitSchema';
import { CarStatusSchema } from 'entities/Car/types/CarStatusSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarData {
    carId: string;
    sensors?: string[];
    traits?: string[];
}

export interface UseCarReq {
    car_id: string;
    sensors?: string;
    traits?: string;
}

export interface CarServerSchema
    extends CarSchema,
        CarIMEITraitSchema,
        CarSignalqTraitSchema,
        CarCommonSpeedTraitSchema {}

export type UseCarRes = CarServerSchema;

export type UseCarResource = UseFetchResource<UseCarRes>;

export interface UseCarServerRes {
    cars: CarServerSchema[];
    meta?: string;
    models: Record<string, CarModelSchema>;
    statuses: CarStatusSchema[];
}

export function useCar(data: UseCarData) {
    const requestData: UseCarReq = {
        car_id: data.carId,
    };

    if (data.sensors) {
        requestData.sensors = data.sensors.join(',');
    }

    requestData.traits = [
        'ReportShowAllModels',
        'ReportLocationDetails',
        'ReportAggressiveScore',
        'ReportSensorTimestamp',
        'ReportTagDetails',
        'ReportVIN',
        'ReportIMEI',
        'ReportSignalq',
        'ReportCommonSpeed',
    ].join(',');

    return useFetch<UseCarReq, UseCarRes, UseCarServerRes>('/api/leasing/car/list', requestData, {
        parser: carParser,
    });
}
