import { CarBeaconSchema } from 'entities/Car/types/CarBeaconSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarBeaconData {
    id: string;
}

export interface UseCarBeaconReq {
    car_id: string;
}

export type UseCarBeaconRes = CarBeaconSchema;

export type UseCarBeaconResource = UseFetchResource<UseCarBeaconRes>;

export interface UseCarBeaconServerRes {
    beacons: CarBeaconSchema[];
}

function carBeaconParser(res: UseCarBeaconServerRes): UseCarBeaconRes {
    return res.beacons[0];
}

export function useCarBeacon({ id }: UseCarBeaconData) {
    return useFetch<UseCarBeaconReq, UseCarBeaconRes, UseCarBeaconServerRes>(
        '/api/leasing/car/beacon/state',
        { car_id: id },
        {
            parser: carBeaconParser,
        },
    );
}
