import { ONE_SECOND } from 'constants/constants';

import { CarDamagesFormSchema } from 'entities/Car/model/CarDamagesFormSchema';
import { CarDamagesSchema } from 'entities/Car/model/CarDamagesSchema';

import { useFetch } from 'shared/hooks/useFetch/useFetch';

export interface UseCarDamagesReq {
    car_id: string;
    report_validated?: boolean;
}

export type UseCarDamagesRes = CarDamagesFormSchema[];

export interface UseCarDamagesServerRes {
    validated_images: Array<{
        elements: Array<Omit<CarDamagesFormSchema, 'user_session_id' | 'created_at'>>;
        group: string;
        title: string;
    }>;
    images: Nullable<CarDamagesSchema[]>;
}

function carDamageParser(res: UseCarDamagesServerRes): UseCarDamagesRes {
    const { validated_images, images } = res;

    const elements = validated_images[0]?.elements;
    const details = images?.reduce((memo, item) => {
        const { image_id, created_at, user_session_id } = item;

        memo[image_id] = { created_at, user_session_id };

        return memo;
    }, {});

    let result: UseCarDamagesRes = [];

    for (let i = 0; i < elements?.length; i++) {
        const element = elements[i];
        const elementDetails = details ? details[element.image_id] : undefined;

        result.push({
            ...element,
            created_at: elementDetails?.created_at ? new Date(elementDetails?.created_at * ONE_SECOND) : undefined,
            user_session_id: elementDetails?.user_session_id,
        });
    }

    return result;
}

export function useCarDamages(id: string) {
    return useFetch<UseCarDamagesReq, UseCarDamagesRes, UseCarDamagesServerRes>(
        '/api/leasing/photo/markup/get',
        {
            car_id: id,
            report_validated: true,
        },
        { parser: carDamageParser },
    );
}
