import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarOfferActionIdReq {
    offer_builder_type: string;
}

export interface UseCarOfferActionIdServerRes {
    offers: [{ constructor_id: string }];
}

export type UseCarOfferActionIdRes = string;

export type UseCarOfferActionIdResource = UseFetchResource<UseCarOfferActionIdRes>;

export function useCarOfferActionId() {
    return useFetch<UseCarOfferActionIdReq, UseCarOfferActionIdRes, UseCarOfferActionIdServerRes>(
        '/api/yandex/offers/create',
        {
            offer_builder_type: 'rental_offer_builder',
        },
        { parser: (res) => res.offers[0].constructor_id },
    );
}
