import { formatSettingRatesRanges } from 'features/SettingsDailyRates/helpers/formatSettingRatesRanges/formatSettingRatesRanges';
import { SettingsRatesFormSchema } from 'features/SettingsDailyRates/types/SettingsRatesFormSchema';

import { useCarOfferActionId } from 'entities/Car/api/useCarOfferActionId/useCarOfferActionId';
import { CAR_OFFER_PRICING_SEP } from 'entities/Car/consts/constants';
import { CarOfferPricingReportSchema } from 'entities/Car/types/CarOfferPricingReportSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarOfferPricingReq {
    action_id: string;
}

export interface UseCarOfferPricingServerRes {
    report: CarOfferPricingReportSchema;
}

export interface UseCarOfferPricingRes {
    report: CarOfferPricingReportSchema;
    ranges: Dict;
    rates: Array<{ id: string; label: string; info?: number | string }>;
    ratesGrid: Optional<SettingsRatesFormSchema>;
    currency: string;
}

export type UseCarOfferPricingResource = UseFetchResource<UseCarOfferPricingRes>;

function carOfferPricingParser(res: UseCarOfferPricingServerRes): UseCarOfferPricingRes {
    const meta = res.report.action_meta;
    const pricing = meta.economy;

    const ranges = formatSettingRatesRanges(pricing.ranges);

    const rates = meta.economy.tariffs.map(({ id, name, cars_count }) => ({
        id,
        label: name,
        info: cars_count,
    }));

    const ratesGrid = meta.economy.grid?.reduce((memo, item) => {
        const { tariff_costs } = item;

        for (let i = 0; i < tariff_costs.length; i++) {
            const { id, daily_cost } = tariff_costs[i];

            memo[item.id + CAR_OFFER_PRICING_SEP + id] = daily_cost ? daily_cost.toString() : '';
        }

        return memo;
    }, {} as SettingsRatesFormSchema);

    return {
        ...res,
        ranges,
        rates,
        ratesGrid,
        currency: meta.currencies[0].name,
    };
}

export function useCarOfferPricing() {
    const resource = useCarOfferActionId();

    return useFetch<UseCarOfferPricingReq, UseCarOfferPricingRes, UseCarOfferPricingServerRes>(
        '/api/leasing/tariffs/list',
        {
            action_id: resource.read(),
        },
        { parser: carOfferPricingParser },
    );
}
