import { CarParksSchema } from 'entities/Car/types/CarParksSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarParksListReq {
    // noop
}

export type UseCarParksListRes = CarParksSchema[];

export interface UseCarParksListServerRes {
    parks: CarParksSchema[];
}

export type UseCarParksListResource = UseFetchResource<UseCarParksListRes>;

function parser(res: UseCarParksListServerRes): UseCarParksListRes {
    return res.parks;
}

export function useCarParksList() {
    return useFetch<UseCarParksListReq, UseCarParksListRes, UseCarParksListServerRes>(
        '/api/leasing/taxi_companies/list',
        {},
        {
            parser,
        },
    );
}
