import { CarModelSchema } from 'entities/Car/types/CarModelSchema';
import { CarRidesSchema } from 'entities/Car/types/CarRidesSchema';
import { RideSchema } from 'entities/Ride/types/RideSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

const RIDES_PAGE_SIZE = 10;

export interface UseCarRidesData {
    id: string;
}

export interface UseCarRidesReq {
    car_id: string;

    numdoc?: number;
    cars_cursor?: number;
    sessions_cursor?: number;

    // since: null,
    // until: null,
    // user_info: true,
    // show_visible_sessions: null,
    // user_id: null,
}

export type UseCarRidesRes = Optional<CarRidesSchema>;

export type UseCarRidesResource = UseFetchResource<UseCarRidesRes>;

export type UseCarBeaconServerRes = {
    hasMore: boolean;
    sessions: RideSchema[];
    models: Record<string, CarModelSchema>;
};

function carRidesParser(res: UseCarBeaconServerRes): UseCarRidesRes {
    return {
        rides: res.sessions,
        models: res.models,
    };
}

export function useCarRides({ id }: UseCarRidesData, disabled?: boolean) {
    return useFetch<UseCarRidesReq, UseCarRidesRes, UseCarBeaconServerRes>(
        '/api/leasing/sessions/history2',
        {
            car_id: id,
            numdoc: RIDES_PAGE_SIZE,
        },
        {
            parser: carRidesParser,
        },
        disabled,
    );
}
