import { ONE_SECOND } from 'constants/constants';

import { DEFAULT_SERVICE_TIME } from 'features/CarService/consts/constants';

import { CarServiceFormSchema } from 'entities/Car/types/CarServiceFormSchema';
import { CarServiceSchema } from 'entities/Car/types/CarServiceSchema';

import { formatTime } from 'shared/helpers/formatTime/formatTime';
import { getDateStartDay } from 'shared/helpers/getDateStartDay/getDateStartDay';
import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

export interface UseCarServiceTagDetails extends Omit<CarServiceSchema, 'car_id' | 'until'> {
    until?: number;
}

export interface UseCarServiceReq {
    tag_id: string;
}

export interface UseCarServiceServerRes {
    history: Array<{
        tag_id: string;
        tag_name: string;
        tag_details: UseCarServiceTagDetails;
        object_id: string;
        event_id: number;
        user_id: string;
        action: string;
        timestamp: number;
    }>;
    tag: UseCarServiceTagDetails;
}

export interface UseCarServiceRes extends Omit<CarServiceFormSchema, 'car' | 'until' | 'until_time'> {
    until: Optional<Date>;
    until_time: Optional<string>;
}

const fetchOptions = {
    parser(res: UseCarServiceServerRes): UseCarServiceRes {
        const service = res.tag;

        const since = new Date(service.since / ONE_SECOND);
        const until = service.until ? new Date(service.until / ONE_SECOND) : undefined;

        return {
            since: getDateStartDay(since),
            since_time: formatTime(since),
            until: until ? getDateStartDay(until) : undefined,
            until_time: until ? formatTime(until) : DEFAULT_SERVICE_TIME,
            job_type: service.job_type ? service.job_type : undefined,
            mileage: service.mileage ? service.mileage.toString() : '',
            job_comment: service.job_comment,
        };
    },
};

export function useCarService(tagId: string) {
    return useFetchRequest<UseCarServiceReq, UseCarServiceRes, UseCarServiceServerRes>(
        '/api/leasing/car/tag/details',
        { tag_id: tagId },
        fetchOptions,
    );
}
