import { formatServerSignals } from 'entities/Signal/helpers/formatServerSignals/formatServerSignals';
import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalFormattedSchema } from 'entities/Signal/types/SignalFormattedSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

const SIGNALS_PAGE_SIZE = 5;

export interface UseCarSignalsData {
    id: string;
    since: number;
    until: number;
}

export interface UseCarSignalsReq {
    since?: Nullable<number>;
    until?: Nullable<number>;
    cars_ids: string;
    signals?: string;

    page_size: number;
    cars_cursor?: number;
    sessions_cursor?: number;
}

export type UseCarSignalsRes = Optional<{
    signals: SignalFormattedSchema[];

    can_get_more_pages: boolean;
}>;

export type UseCarSignalsResource = UseFetchResource<UseCarSignalsRes>;

export interface UseCarSignalsServerRes {
    signals: SignalSchema[];
    signals_descriptions: SignalDescriptionDictSchema;

    meta?: string;
    can_get_more_pages: boolean;
    next_cars_cursor?: number;
    next_sessions_cursor?: number;
}

function signalsParser(res: UseCarSignalsServerRes): UseCarSignalsRes {
    return {
        signals: formatServerSignals(res.signals, res.signals_descriptions),
        can_get_more_pages: res.can_get_more_pages,
    };
}

export function useCarSignals({ id, since, until }: UseCarSignalsData, disabled?: boolean) {
    return useFetch<UseCarSignalsReq, UseCarSignalsRes, UseCarSignalsServerRes>(
        '/api/leasing/signals/list',
        {
            since,
            until,
            cars_ids: id,
            page_size: SIGNALS_PAGE_SIZE,
        },
        {
            parser: signalsParser,
        },
        disabled,
    );
}
