import { CarSensorSchema } from 'entities/Car/types/CarSensorSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarTelematicsData {
    id: string;
}

export interface UseCarTelematicsReq {
    car_id: string;
    sensors?: string;
}

export type CarTelematicsRes = Record<string, CarSensorSchema>;

export type UseCarTelematicsRes = CarTelematicsRes;

export type UseCarTelematicsResource = UseFetchResource<UseCarTelematicsRes>;

export interface UseCarTelematicsServerRes {
    sensors: CarSensorSchema[];
}

function carTelematicsParser(res: UseCarTelematicsServerRes): UseCarTelematicsRes {
    const { sensors = [] } = res;

    return sensors.reduce((result, sensor) => {
        const { name } = sensor;

        result[name] = sensor;

        return result;
    }, {});
}

export function useCarTelematics(data: UseCarTelematicsData, disabled?: boolean) {
    return useFetch<UseCarTelematicsReq, UseCarTelematicsRes, UseCarTelematicsServerRes>(
        '/api/leasing/car/telematics/state',
        {
            car_id: data.id,
            sensors: ['fuel_level', 'fuel_distance'].join(','),
        },
        {
            parser: carTelematicsParser,
        },
        disabled,
    );
}
