import { CarGroupSchema } from 'entities/Car/types/CarGroupSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseGroupSignalFormReq {}

export interface UseGroupSignalFormServerRes {
    objects: CarGroupSchema;
}

export type UseGroupSignalFormRes = CarGroupSchema;

export type UseGroupSignalFormResource = UseFetchResource<UseGroupSignalFormRes>;

function carsGroupsParser(res: UseGroupSignalFormServerRes): UseGroupSignalFormRes {
    return res.objects;
}

export function useCarsGroups() {
    return useFetch<UseGroupSignalFormReq, UseGroupSignalFormRes, UseGroupSignalFormServerRes>(
        '/api/leasing/named_filters/get',
        {},
        {
            parser: carsGroupsParser,
        },
    );
}
