import { CarsFilter } from 'entities/Car/consts/CarsFilter';

import { DateFilter } from 'shared/consts/DateFilter';
import { INITIAL_DATE_FILTERS } from 'shared/consts/filters';

// Cars
export const INITIAL_CARS_FILTERS = {
    // Custom for CarLove received via 'carlove_custom_filters' flag
    [CarsFilter.CLASS]: null,

    [CarsFilter.NO_SH]: null,
    [CarsFilter.TELEMATICS]: null,
    [CarsFilter.CAMERA]: null,
    [CarsFilter.FRESH_ISSUE_DATE]: null,
    [CarsFilter.PARK_ID]: null,
    [CarsFilter.SERVICE]: null,
    [CarsFilter.STATUS]: null,
    [CarsFilter.SIGNALQ_STATUS]: null,
};
export const EXISTING_CARS_FILTERS = [
    // Place for custom filter
    CarsFilter.CLASS,

    CarsFilter.NO_SH,
    CarsFilter.TELEMATICS,
    CarsFilter.CAMERA,
    CarsFilter.FRESH_ISSUE_DATE,
    CarsFilter.PARK_ID,
    CarsFilter.SERVICE,
    CarsFilter.STATUS,
    CarsFilter.SIGNALQ_STATUS,
];
export const STRING_CARS_FILTERS = [
    CarsFilter.CLASS,
    CarsFilter.FRESH_ISSUE_DATE,
    CarsFilter.PARK_ID,
    CarsFilter.STATUS,
    CarsFilter.SIGNALQ_STATUS,
];
export const BOOLEAN_CARS_FILTERS = [CarsFilter.NO_SH, CarsFilter.TELEMATICS, CarsFilter.CAMERA, CarsFilter.SERVICE];

// Car Sessions
export const INITIAL_CAR_SESSIONS_FILTERS = INITIAL_DATE_FILTERS;
export const EXISTING_CAR_SESSIONS_FILTERS = [DateFilter.SINCE, DateFilter.UNTIL];
